<!--
     2/24/2012: peg-solitaire (hsw)
-->
<xsl:transform version="2.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ixsl="http://saxonica.com/ns/interactiveXSLT"
  xmlns:xs="http://www.w3.org/2001/XMLSchema"
  xmlns:peg="urn:peg-solitaire"
  extension-element-prefixes="ixsl"
>
  <!-- initial startup -->
  <xsl:template match="/" name="main">
    <xsl:call-template name="peg:print">
      <xsl:with-param name="board" select="doc('English.xml')"/>
    </xsl:call-template>
  </xsl:template>

  <!-- change a single field (in place) -->
  <xsl:template name="peg:toggle">       
    <xsl:param name="new"/>

    <ixsl:set-attribute name="piece" select="$new"/>
    <ixsl:set-attribute name="src" select="concat('gif/',$new,@color,'.gif')"/>
  </xsl:template>

  <!-- check if move possible; if so, do it. return whether done or not -->
  <xsl:function name="peg:move" as="xs:boolean">
    <xsl:param name="p1"/>
    <xsl:param name="p2"/>
    <xsl:param name="p3"/>

    <xsl:variable name="mph" 
      select="$p1[@piece='m'] and $p2[@piece='p'] and $p3[@piece='h']"
    />

    <xsl:if test="$mph">
      <xsl:for-each select="$p1">
        <xsl:call-template name="peg:toggle">
          <xsl:with-param name="new" select="'h'"/>
        </xsl:call-template>
      </xsl:for-each>
      <xsl:for-each select="$p2">
        <xsl:call-template name="peg:toggle">
          <xsl:with-param name="new" select="'h'"/>
        </xsl:call-template>
      </xsl:for-each>
      <xsl:for-each select="$p3">
        <xsl:call-template name="peg:toggle">
          <xsl:with-param name="new" select="'p'"/>
        </xsl:call-template>
      </xsl:for-each>
    </xsl:if>

    <xsl:value-of select="$mph"/>
  </xsl:function>

  <!-- print board configuration (once) -->
  <xsl:template name="peg:print">       
    <xsl:param name="board"/>

    <xsl:result-document href="#board" method="replace-content">
      <table cellpadding="0" cellspacing="0">

        <xsl:for-each select="1 to 9">
          <xsl:variable name="row" select="."/>
                   
          <tr> 
            <xsl:for-each select="1 to 9">
              <xsl:variable name="column" select="."/>
              <xsl:variable name="piece" 
                select="name($board/*/row[$row]/*[$column])"
              />
              <xsl:variable name="color" 
                select="if ((($row + $column) mod 2)=1) then 'w' else 'b'"
              />

              <td> 
                <img piece="{$piece}" color="{$color}" style="display:block" 
                  border="0" src="gif/{$piece}{$color}.gif"
                />
              </td> 
            </xsl:for-each>
          </tr> 
        </xsl:for-each>
      </table>
    </xsl:result-document>       
  </xsl:template>

  <!-- field action: (de-)select, move or modify board -->
  <xsl:template match="img[@piece]" mode="ixsl:onclick">
    <xsl:choose>
      <!-- play mode -->
      <xsl:when test="ixsl:page()//div[@id='mode']/img/@id = 'edit'">
        <xsl:choose>
          <xsl:when test="count(ixsl:page()//img[@piece='m'])">
            <xsl:choose>
              <xsl:when test="@piece='m'">
                <xsl:call-template name="peg:toggle">
                  <xsl:with-param name="new" select="'p'"/>
                </xsl:call-template>
              </xsl:when>

              <xsl:when test="@piece='h'">
                <xsl:variable name="x" 
                  select="1+count(../preceding-sibling::*)"
                />

                <xsl:choose>
                  <xsl:when test="peg:move(../preceding-sibling::*[2]/img, 
                                           ../preceding-sibling::*[1]/img, .)"
                  />
                  <xsl:when test="peg:move(../following-sibling::*[2]/img, 
                                           ../following-sibling::*[1]/img, .)"
                  />
                  <xsl:when 
                    test="peg:move(../../preceding-sibling::*[2]/td[$x]/img, 
                                   ../../preceding-sibling::*[1]/td[$x]/img, .)"
                  />
                  <xsl:when 
                    test="peg:move(../../following-sibling::*[2]/td[$x]/img, 
                                   ../../following-sibling::*[1]/td[$x]/img, .)"
                  />
                </xsl:choose>
              </xsl:when>
            </xsl:choose>
          </xsl:when>

          <!-- no marked piece -->
          <xsl:otherwise>
            <xsl:if test="@piece='p'">
              <xsl:call-template name="peg:toggle">
                <xsl:with-param name="new" select="'m'"/>
              </xsl:call-template>
            </xsl:if>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>

      <!-- Edit mode -->
      <xsl:otherwise>
        <xsl:call-template name="peg:toggle">
          <xsl:with-param name="new" select="translate(@piece, 'fhp', 'hpf')"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- load predefined initial position -->
  <xsl:template match="img[not(@piece) and not(../@id)]" mode="ixsl:onclick">
    <xsl:call-template name="peg:print">
      <xsl:with-param name="board" select="doc(concat(@id,'.xml'))"/>
    </xsl:call-template>
  </xsl:template>

  <!-- toggle play mode on(edit) and off(Edit) -->
  <xsl:template match="div[@id='mode']" mode="ixsl:onclick">
    <xsl:result-document href="#mode" method="replace-content">
      <xsl:variable name="label" 
        select="if (img/@id='edit') then 'Edit' else 'edit'"
      />
      <img id="{$label}" border="0" src="gif/{$label}.gif"/>

      <!-- unmark the at most one marked peg -->
      <xsl:for-each select="ixsl:page()//img[@piece='m']">
        <xsl:call-template name="peg:toggle">
          <xsl:with-param name="new" select="'p'"/>
        </xsl:call-template>
      </xsl:for-each>
    </xsl:result-document>       
  </xsl:template>

</xsl:transform>
